from cube import *
from time import sleep

def solid_colors(delay):
    fb_set_all(0xFF, 0x00, 0x00)
    cube_update()
    sleep(delay)
    fb_set_all(0x00, 0xFF, 0x00)
    cube_update()
    sleep(delay)
    fb_set_all(0x00, 0x00, 0xFF)
    cube_update()
    sleep(delay)

def row_column_sweep(delay):
    # Sweep across three colors (R,G,B)
    for color in range(3):
	# Sweep across each row
	for row in range(8):
	    fb_set_clear()
	    for column in range(8):
		for layer in range(8):
		    if color % 3 == 0:
			fb_set_pixel(row, column, layer, 0xFF, 0x00, 0x00)
		    elif color % 3 == 1:
			fb_set_pixel(row, column, layer, 0x00, 0xFF, 0x00)
		    else:
			fb_set_pixel(row, column, layer, 0x00, 0x00, 0xFF)
	    cube_update()
	    sleep(delay)
	# Sweep across each column
	for column in range(8):
	    fb_set_clear()
	    for row in range(8):
		for layer in range(8):
		    if color % 3 == 0:
			fb_set_pixel(row, column, layer, 0xFF, 0x00, 0x00)
		    elif color % 3 == 1:
			fb_set_pixel(row, column, layer, 0x00, 0xFF, 0x00)
		    else:
			fb_set_pixel(row, column, layer, 0x00, 0x00, 0xFF)
	    cube_update()
	    sleep(delay)
	# Sweep across each layer
	for layer in range(7, -1, -1):
	    fb_set_clear()
	    for layer_2 in range(8):
		if color % 3 == 0:
		    if layer_2 == layer:
			set_layer(layer_2, 0xFF, 0x00, 0x00)
		elif color % 3 == 1:
		    if layer_2 == layer:
			set_layer(layer_2, 0x00, 0xFF, 0x00)
		else:
		    if layer_2 == layer:
			set_layer(layer_2, 0x00, 0x00, 0xFF)
	    cube_update()
	    sleep(delay)
	    
